function P = recurrenceProb(obj,frac,varargin)
%RECURRENCYPROB Calculate the recurrence probability for AdjacencyMatrix
%obj
%   P = RECURRENCYPROB(obj,frac) will return the probability, P, that a
%   connection from neuron i to j of weight w will be reciprocated with a
%   connection from j to i of weight >= frac*w
%   Muscles will be removed from consideration

pTest = false;
modules = false;
for i = 1:2:numel(varargin)
    switch varargin{i}
        case 'pTest'
            pTest = varargin{i+1};
        case 'modules'
            modules = varargin{i+1};
    end
end

[reducedMat A] = getSubMatrix(obj,AdjacencyMatrix.muscles,'remove');

nIters = 200;
[P,N] = countRecurrence(A);



if pTest
    Prand = zeros(nIters,1);
    for i = 1:nIters
        Arand = randmio_dir(A,20);
        [Prand(i),N] = countRecurrence(Arand);
    end
    fprintf('Average recurrence percent for random networks: %.2f\n',mean(Prand)*100);
    
end

% Count within-module recurrence
if modules
    [matrices Q] = getCommunitiesMM(obj,'quiet');
    N = 0;
    R = 0;
    for i = 1:numel(matrices)
        Amod = getSquareMatrix(matrices{i});
        [Pmod,Nmod] = countRecurrence(Amod);
        N = N + Nmod;
        R = R + Pmod*Nmod;
    end
    
    fprintf('Average recurrence percent for within-module connections: %.2f\n',R*100/N);
end

    function [P N] = countRecurrence(A)
        
        [I,J] = ind2sub(size(A),find(A>0));
        count = 0;
        for kk = 1:numel(I)
            %     fprintf('%u %u %u\n',A(I(kk),J(kk)), A(J(kk),I(kk)),double(A(J(kk),I(kk)) > frac*A(I(kk),J(kk))));
            if A(J(kk),I(kk)) > frac*A(I(kk),J(kk));
                count = count+1;
            end
        end
        P = count/numel(I);
        N = numel(I);
    end
end

